;*******************************************************************************
;
;	C Compiler for M16C/60
;       Copyright 1995-1998 MITSUBISHI ELECTRIC CORPORATION
;       AND MITSUBISHI ELECTRIC SEMICONDUCTOR SYSTEMS CORPORATION
;       All Rights Reserved.
;
;	Written by T.Aoyama
;
;       sect30.inc     : section definition
;       This program is applicable when using the basic I/O library
;
;       $Id: sect30.inc,v 1.9 2000/06/20 09:07:11 simomura Exp $
;
;******************************************************************************
;
; FSt 14.2.2001
; Entwickelt aus der sect30.inc v1.9 aus dem NC30WA-Paket
; und sect30.inc v1.5 von der Glyn-CD mit Anpassungen an den KD30 Debugger
;
; FSt 15.2.2001
; Bedingte Assemblierung fr eigene InterruptVectorTabelle
;
; FSt 10.3.2001
; auf Flash Version gendert
;
; FSt	24.7.2001
; Speicheraufbau und Sections im NC30 Manual S. 32ff beschrieben
;
;******************************************************************************

;---------------------------------------------------------------
;
; 	Arrangement of section
;
;---------------------------------------------------------------
; Near RAM data area
;---------------------------------------------------------------
; SBDATA area
	.section	data_SE,DATA
	.org	00000400H            ;FSt: hier beginnt interes RAM
data_SE_top:

	.section	bss_SE,DATA,ALIGN
bss_SE_top:

	.section	data_SO,DATA
data_SO_top:

	.section	bss_SO,DATA
bss_SO_top:

; near RAM area
	.section	data_NE,DATA,ALIGN
data_NE_top:

	.section	bss_NE,DATA,ALIGN
bss_NE_top:

	.section	data_NO,DATA
data_NO_top:

	.section	bss_NO,DATA
bss_NO_top:

;---------------------------------------------------------------
; Stack area
;---------------------------------------------------------------
	.section	stack,DATA,ALIGN
	.blkb	STACKSIZE
stack_top:

	.section	istack,DATA,ALIGN
	.blkb	ISTACKSIZE
istack_top:


;---------------------------------------------------------------
;	heap section
;---------------------------------------------------------------
	.if 0
	;Heap ins externe RAM verlegt
	.section	heap,DATA
heap_top:
	.blkb	HEAPSIZE
	.endif

;---------------------------------------------------------------
;zum testen ob RAM-Gre berluft
;---------------------------------------------------------------
	.section RAM_SIZE_CHECK,data
	.org	LAST_RAM_ADDR+1

;---------------------------------------------------------------
;
;	ab hier ext. Memory
;
;---------------------------------------------------------------

;---------------------------------------------------------------
; Near ROM data area
;---------------------------------------------------------------
	.section	rom_NE,ROMDATA
	.org		FIRST_EXT_MEM_ADR
rom_NE_top:

	.section	rom_NO,ROMDATA
rom_NO_top:


;---------------------------------------------------------------
; FSt
; Hier richten wir mal Sections fr das SRAM ein
; SRAM hngt am /CS2: Adr. 8000h - 28000h
;---------------------------------------------------------------
;
	.section	heap,DATA
	.org		00008000h

	.glb _sram
_sram:

	.glb	_heap_start
	.glb	_heap_end

_heap_start:
	.blkb	HEAPSIZE
_heap_end:

	.section sram_data_NE,data,ALIGN
sram_data_NE_top:

	.section sram_bss_NE,data,align
sram_bss_NE_top:

	.section sram_data_NO,data
sram_data_NO_top:

	.section sram_bss_NO,data
sram_bss_NO_top:

	.section sram_data_FE,data	;,ALIGN
	.org		00010000h
sram_data_FE_top:

	.section sram_bss_FE,data,align
sram_bss_FE_top:

	.section sram_data_FO,data
sram_data_FO_top:

	.section sram_bss_FO,data
sram_bss_FO_top:


;---------------------------------------------------------------
; Far RAM data area
;---------------------------------------------------------------
	.section	data_FE,DATA
	; FSt: .org		00010000H          ;FSt: far meint >64k
data_FE_top:

	.section	bss_FE,DATA,ALIGN
bss_FE_top:

	.section	data_FO,DATA
data_FO_top:

	.section	bss_FO,DATA
bss_FO_top:


;---------------------------------------------------------------
; FSt
; Hier richten wir mal Sections fr das externe FLASH ein
; FLASH hngt am /CS0: Adr. 30000h - BFFFFh
;---------------------------------------------------------------
;
	.section	flash,DATA
	.org		00030000h

	;Auf Grund der Segmentierung im Flash starten wir erst bei 40000h
	;Flash belegt damit 40000h bis 7FFFFh und an der Segmentierung ndert sich nichts.
	;!!! WICHTIG !!!
	; Bezglich Segmentierung und Flash: s. FLASH.C

	.org		00040000h

	.glb _flash
_flash:

	.section flash_data_FE,data	;,ALIGN
flash_data_FE_top:

	.section flash_bss_FE,data,align
flash_bss_FE_top:

	.section flash_data_FO,data
flash_data_FO_top:

	.section flash_bss_FO,data
flash_bss_FO_top:

;---------------------------------------------------------------
;zum testen ob FLASH-Gre berluft
;---------------------------------------------------------------
	.section FLASH_SIZE_CHECK,data
	.org		000C0000h		; zum testen von Bereichsberlufen


;---------------------------------------------------------------
; Far ROM data area
;---------------------------------------------------------------
	.section	rom_FE,ROMDATA
	.org    FLASH_ADR
rom_FE_top:

	.section	rom_FO,ROMDATA
rom_FO_top:

;---------------------------------------------------------------
; Initial data of 'data' section
;---------------------------------------------------------------
	.section	data_SEI,ROMDATA
data_SEI_top:

	.section	data_SOI,ROMDATA
data_SOI_top:

	.section	data_NEI,ROMDATA
data_NEI_top:

	.section	data_NOI,ROMDATA
data_NOI_top:

	.section	data_FEI,ROMDATA
data_FEI_top:

	.section	data_FOI,ROMDATA
data_FOI_top:


;---------------------------------------------------------------
; FSt 26.4.02
; Initial data of 'sram' sections
;---------------------------------------------------------------

	.section sram_data_NEI,romdata
sram_data_NEI_top:

	.section sram_data_NOI,romdata
sram_data_NOI_top:

	.section sram_data_FEI,romdata
sram_data_FEI_top:

	.section sram_data_FOI,romdata
sram_data_FOI_top:

	.section sram_bss_FOI,romdata
sram_bss_FOI_top:


;---------------------------------------------------------------
; Switch Table Section
;---------------------------------------------------------------
	.section        switch_table,ROMDATA
switch_table_top:


;---------------------------------------------------------------
; code area
;---------------------------------------------------------------

	.section	program

	.section	program_S

  .org INTERRUPT_ADR
	.section	interrupt


;---------------------------------------------------------------
; variable vector section
;---------------------------------------------------------------
	.section	vector		; variable vector table

	.org	VECTOR_ADR

  .include inttab.inc

;===============================================================
; fixed vector section
;---------------------------------------------------------------

	.section	fvector			; fixed vector table

	.org     000ffe00h    ; for special pages

;===============================================================
; special page defination
;---------------------------------------------------------------
;	macro is defined in ncrt0.a30
;	Format: SPECIAL number
;
;---------------------------------------------------------------
;	SPECIAL 255
;	SPECIAL 254
;	SPECIAL 253
;	   :
;	   :
;	(omitted)
;	   :
;	   :
;	SPECIAL 24
;	SPECIAL 23
;	SPECIAL 22
;	SPECIAL 21
;	SPECIAL 20
;	SPECIAL 19
;	SPECIAL 18
;
;===============================================================
; fixed vector section
;---------------------------------------------------------------
	.org	000fffdch
UDI:
	.lword	(dummy_int | (PROTECT_ID1 << 24))
OVER_FLOW:
	.lword	(dummy_int | (PROTECT_ID2 << 24))
BRKI:
	.lword	(dummy_int)
ADDRESS_MATCH:
	.lword	(dummy_int | (PROTECT_ID3 << 24))
SINGLE_STEP:
	.lword	(dummy_int | (PROTECT_ID4 << 24))
WDT:
	.lword	(dummy_int | (PROTECT_ID5 << 24))
DBC:
	.lword	(dummy_int | (PROTECT_ID6 << 24))
NMI:
	.lword	(dummy_int | (PROTECT_ID7 << 24))
RESET:
	.lword	(start | (PROTECT_ROM << 24))
;
;*******************************************************************************
;
;	C Compiler for M16C/60
;       Copyright 1995-1998 MITSUBISHI ELECTRIC CORPORATION
;       AND MITSUBISHI ELECTRIC SEMICONDUCTOR SYSTEMS CORPORATION
;       All Rights Reserved.
;
;*******************************************************************************

